# $Id$
# Some of the CAKE R modules are based on mkin, 
# Modifications developed by Hybrid Intelligence (formerly Tessella), part of
# Capgemini Engineering, for Syngenta, Copyright (C) 2011-2022 Syngenta
# Tessella Project Reference: 6245, 7247, 8361, 7414, 10091

#    The CAKE R modules are free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Produces solutions to the SFO equation given times t and parameters M_0 and k.
SFO.solution <- function(t, parent.0, k) {
  parent = parent.0 * exp(-k * t)
}

# Produces solutions to the DFOP equation given times t and parameters M_0, k1, k2 and g.
DFOP.solution <- function(t, parent.0, k1, k2, g) {
  parent = g * parent.0 * exp(-k1 * t) + (1 - g) * parent.0 * exp(-k2 * t)
}

# Produces solutions to the FOMC equation given times t and parameters M_0, alpha and beta.
FOMC.solution <- function(t, parent.0, alpha, beta) {
  parent = parent.0/(t/beta + 1)^alpha
}

# Produces solutions to the HS equation given times t and parameters M_0, k1, k2 and tb.
HS.solution <- function (t, parent.0, k1, k2, tb) {
  parent = ifelse(t <= tb, parent.0 * exp(-k1 * t), parent.0 * exp(-k1 * tb) * exp(-k2 * (t - tb)))
}

# Produces solutions to the IORE equation given times t and parameters M_0, k and N.
IORE.solution <- function(t, parent.0, k, N) {
    if (N == 1) {
        parent = parent.0 * exp(-k * t)
    }
    else {
        parent = (parent.0 ^ (1 - N) - (1 - N) * k * t) ^ (1 / (1 - N))
    }

    return(parent)
}